/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFileImpDrvNT.h,v 1.3 2000/05/13 06:34:21 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CFileImpDrvNT_h	// [
#define Included_CFileImpDrvNT_h

#include "pgpClassesConfig.h"
#include "CFileImp.h"

_PGP_BEGIN

// Class CFileImpDrvNT

class CFileImpDrvNT : public CFileImp
{
	friend class CPFLImpFactoryDrvNT;

public:
	enum {kSlashChar = '\\'};

private:
	CFileImpDrvNT();
	~CFileImpDrvNT();

	CComboError	GetLength(PGPUInt64& length) const;
	CComboError	GetUniqueFileId(PGPUInt64& fileId) const;

	CComboError	SetIsCompressed(PGPBoolean isCompressed);
	CComboError	SetLength(PGPUInt64 length);

	void		Flush();

	CComboError	Open(const char *path, PGPUInt32 flags);
	CComboError	Close();
	CComboError	Delete(const char *path);
	CComboError	Move(const char *oldPath, const char *newPath);

	CComboError	Read(void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
	CComboError	Write(const void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;

private:
	HANDLE	mFileHandle;

	ERESOURCE	mNewPagingIoResource;
	PERESOURCE	mPOldPagingIoResource;
	PERESOURCE	*mPPPagingIoResource;

	CComboError	ReplacePagingIoResource();
	void		RestorePagingIoResource();

	void	SafeReplaceResource(PERESOURCE& pOldResource, 
		PERESOURCE pNewResource);

	PGPBoolean	IsSlashChar(char c) const
	{
		return (c == kSlashChar);
	}

	PGPBoolean	IsUNCPath(const char *path) const;
};

_PGP_END

#endif	// ] Included_CFileImpDrvNT_h
